# System Architecture Diagram

## 🔄 Complete Workflow Diagram

```
┌─────────────────────────────────────────────────────────────────┐
│                   CUSTOMER REVIEWS WORKFLOW                     │
└─────────────────────────────────────────────────────────────────┘

STEP 1: CUSTOMER SUBMITS REVIEW
═══════════════════════════════
    
    Customer Dashboard
    ┌─────────────────┐
    │ Submit Review   │
    │ - Name          │
    │ - Rating (1-5)  │
    │ - Review Text   │
    │ - Submit Btn    │
    └────────┬────────┘
             │
             ▼
    Database Insert
    ┌─────────────────────────────┐
    │ INSERT INTO reviews         │
    │ (user_id, rating, text...)  │
    │ status = 'PENDING'  ◄───── Initially pending
    └─────────────────────────────┘
             │
             ▼
    Admin Dashboard
    ┌─────────────────────────────┐
    │ Feedback Tab                │
    │ Show: PENDING Reviews       │
    │ [Approve] [Delete]          │
    └──────────────┬──────────────┘
                   │

STEP 2: ADMIN APPROVES REVIEW
═════════════════════════════

                   Admin Clicks [Approve]
                        │
                        ▼
    Database Update
    ┌─────────────────────────────┐
    │ UPDATE reviews              │
    │ SET status = 'APPROVED'     │ ◄──── Changed to approved
    │ WHERE id = X                │
    └─────────────────────────────┘
             │
             ▼
    Review Now Visible

STEP 3: HOMEPAGE DISPLAYS TESTIMONIALS
═════════════════════════════════════

Homepage (index.php) Loads
    ┌────────────────────────────┐
    │ Page Ready                 │
    └────────────────┬───────────┘
                     │
                     ▼ (DOMContentLoaded)
    ┌────────────────────────────┐
    │ JavaScript Triggers        │
    │ loadTestimonials()         │
    └────────────────┬───────────┘
                     │
                     ▼
    ┌────────────────────────────────────────┐
    │ API Call                               │
    │ GET api_handler.php?action=            │
    │     get_approved_reviews               │
    └────────────────┬───────────────────────┘
                     │
                     ▼
    ┌─────────────────────────────────────────────┐
    │ Database Query                              │
    │ SELECT * FROM reviews r                     │
    │ LEFT JOIN users u ON r.user_id = u.id      │
    │ WHERE r.status = 'APPROVED'                 │
    │ ORDER BY r.created_at DESC LIMIT 20         │
    └─────────────────┬───────────────────────────┘
                      │
                      ▼
    ┌────────────────────────────────────────┐
    │ JSON Response                          │
    │ {                                      │
    │   success: true,                       │
    │   data: [                              │
    │     {id, rating, review_text,          │
    │      customer_name, ...}               │
    │   ]                                    │
    │ }                                      │
    └─────────────────┬──────────────────────┘
                      │
                      ▼
    ┌─────────────────────────────────────┐
    │ JavaScript Renders                  │
    │ renderTestimonials(data)            │
    │ - Build testimonial cards          │
    │ - Generate star ratings            │
    │ - Insert into #testimonialsContainer│
    └──────────────┬──────────────────────┘
                   │
                   ▼
    ┌──────────────────────────────────────┐
    │ Slick Slider Initialized            │
    │ - Set fade animation                │
    │ - Enable navigation arrows          │
    │ - Set infinite loop                 │
    └──────────────┬───────────────────────┘
                   │
                   ▼
    ┌──────────────────────────────────┐
    │ Homepage Shows Testimonials      │
    │ [◄ Review 1 ►]                   │
    │ Name: John Doe                   │
    │ Rating: ★★★★★ (5/5)             │
    │ Text: "Great service!"           │
    └──────────────────────────────────┘

STEP 4: AUTO-REFRESH (Every 60 Seconds)
═════════════════════════════════════════

    60 Second Timer Fires
            │
            ▼
    loadTestimonials() called again
            │
            ▼
    (Repeats API call and rendering)
            │
            ▼
    New reviews appear automatically
    (if admin just approved them)
            │
            ▼
    No page reload needed ✓


┌──────────────────────────────────────────────────────────────────┐
│                    SYSTEM ARCHITECTURE                            │
└──────────────────────────────────────────────────────────────────┘

FRONTEND (Browser)          BACKEND (Server)         DATABASE
───────────────────         ────────────────         ────────

┌──────────────────┐
│   index.php      │       ┌──────────────────┐
│  Homepage        │◄─────►│  api_handler.php │◄─────► reviews
│                  │  AJAX │                  │        table
│  loadTestitonials│       │ getApprovedReviews       
│  renderTestitonials      │                  │       users
│                  │  JSON │  (filters status │       table
└──────────────────┘       │   = 'approved')  │
                            └──────────────────┘
         │
         │
         ▼ (every 60 sec)
    Auto-refresh
    (setInterval)


┌──────────────────────────────────────────────────────────────────┐
│                    DATA FLOW DIAGRAM                              │
└──────────────────────────────────────────────────────────────────┘

    Customer Dashboard          Admin Dashboard         Homepage
    ──────────────────          ───────────────         ────────
    
    Reviews Table              Reviews Table           Approved Reviews
    (All Statuses)             (All Statuses)          (Filtered)
    
    ┌──────────────┐          ┌──────────────┐        ┌──────────────┐
    │ ID   │Status │          │ ID   │Status │        │ ID   │Status │
    ├──────┼───────┤          ├──────┼───────┤        ├──────┼───────┤
    │ 1    │pending│    →     │ 1    │pending│   →    │ (none)       │
    │ 2    │pending│  [Approve] 2    │apprvd │   →    │ 2    │apprvd │
    │ 3    │apprvd │    →     │ 3    │apprvd │   →    │ 3    │apprvd │
    │ 4    │apprvd │          │ 4    │apprvd │        │ 4    │apprvd │
    └──────┴───────┘          └──────┴───────┘        └──────┴───────┘
                                   │
                                   │ Admin Controls
                                   │ (Approve/Delete)


┌──────────────────────────────────────────────────────────────────┐
│                    HTML STRUCTURE                                 │
└──────────────────────────────────────────────────────────────────┘

Testimonials Container (Dynamic)
┌────────────────────────────────────┐
│ <div id="testimonialsContainer"    │
│      class="vs-carousel">          │
│                                    │
│  ┌──────────────────────────────┐  │
│  │ <div class="testi-content">  │  │
│  │   ★★★★★ John Doe            │  │
│  │   "Great service!"           │  │
│  │ </div>                        │  │
│  └──────────────────────────────┘  │
│                                    │
│  ┌──────────────────────────────┐  │
│  │ <div class="testi-content">  │  │
│  │   ★★★★★ Jane Smith          │  │
│  │   "Very professional!"       │  │
│  │ </div>                        │  │
│  └──────────────────────────────┘  │
│                                    │
│  [◄ Navigation Arrows ►]           │
│                                    │
└────────────────────────────────────┘


┌──────────────────────────────────────────────────────────────────┐
│                    API RESPONSE FORMAT                            │
└──────────────────────────────────────────────────────────────────┘

GET api_handler.php?action=get_approved_reviews

Response:
{
  "success": true,
  "data": [
    {
      "id": 1,
      "user_id": 2,
      "rating": 5,
      "review_text": "Excellent service!",
      "status": "approved",
      "customer_name": "John Doe",
      "created_at": "2025-02-04 10:30:00"
    },
    {
      "id": 2,
      "user_id": 3,
      "rating": 5,
      "review_text": "Very professional!",
      "status": "approved",
      "customer_name": "Jane Smith",
      "created_at": "2025-02-04 11:15:00"
    }
  ]
}


┌──────────────────────────────────────────────────────────────────┐
│                    JAVASCRIPT EXECUTION FLOW                      │
└──────────────────────────────────────────────────────────────────┘

                    Page Loads
                        │
                        ▼
            DOMContentLoaded Event
                        │
        ┌───────────────┴───────────────┐
        │                               │
        ▼                               ▼
    loadTestimonials()           setInterval(60000ms)
    └─ fetch API                 └─ Repeats every 60s
       └─ parse JSON
          └─ renderTestimonials()
             ├─ Clear container
             ├─ Build HTML cards
             ├─ Generate stars
             ├─ Insert into DOM
             └─ Initialize Slider
                ├─ Check if already initialized
                ├─ Destroy if needed
                └─ Initialize Slick with config


┌──────────────────────────────────────────────────────────────────┐
│                    BROWSER TIMELINE                               │
└──────────────────────────────────────────────────────────────────┘

0s:  Page starts loading
     ↓
2s:  HTML loaded, scripts parsed
     ↓
2.5s: DOMContentLoaded fires
      ├─ loadTestimonials() called
      ├─ API fetch request sent
      ↓
3s:   Database query executes
      ├─ Filter approved reviews
      ├─ Join with users table
      ↓
3.2s: API response received (JSON)
      ├─ renderTestimonials() called
      ├─ HTML generated
      ├─ DOM updated
      ├─ Slick initialized
      ↓
3.5s: Testimonials visible! ✓
      ├─ Navigation works
      ├─ Animations enabled
      ↓
63s:  60-second timer fires
      ├─ loadTestimonials() called again
      ├─ API fetch request sent (repeat)
      ↓
63.5s: New testimonials appear (if any approved)


This is a complete real-time system that keeps testimonials
automatically updated with zero user intervention!
